<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {
	public function __construct()
    {
        parent::__construct();
		is_logged_in();
		
		$this->load->model('Model_alat','m_alat', True);
    }
	public function index()
    {
		$data = array( 
			'konten' => 'backend/main',
			'data_grafik' => $this->json_pie(),
			'data_kalib' => $this->json_kalib()
		);

		$this->load->view('backend/wrapper',$data);

    }
	function json_pie()
	{
		$get_data = $this->m_alat->get_pie_alat();
		$data = array();
		foreach ($get_data->result() as $value) {
			$arr['label'] = $value->nama." : ".$value->jml;
			$arr['data']  = $value->jml;
			array_push($data, $arr);
		}
		return $data;
	}
	function json_kalib()
	{
		$get_data = $this->m_alat->alat_kalibrasi();
		$skrng = date('Y-m-d');
		$batas = date('Y-m-d',strtotime('+6 months'));
		$belum = 0;
		$expired = 0;
		$akan = 0;
		$aman = 0;
		foreach ($get_data->result() as $value) {
			if($value->tgl_kalib2 == null){
				$belum++;
			}elseif($value->tgl_kalib2 < $skrng){
				$expired++;
			}elseif($value->tgl_kalib2 >= $skrng && $value->tgl_kalib2 <= $batas){
				$akan++;
			}else{
				$aman++;
			}
		}
		$data = array();
		$arr['label'] = "Belum Kalibrasi : ".$belum;//belum pernah
		$arr['data']  = $belum;
		$arr['color']  = "#e1e1e1";
		array_push($data, $arr);

		$arr['label'] = "Expired : ".$expired;//lewat
		$arr['data']  = $expired;
		$arr['color']  = "#e13232";
		array_push($data, $arr);
		
		$arr['label'] = "Akan Habis : ".$akan;//6 bln
		$arr['data']  = $akan;
		$arr['color']  = "#e1e132";
		array_push($data, $arr);
		
		$arr['label'] = "Masih Berlaku : ".$aman;//>6 bln
		$arr['data']  = $aman;
		$arr['color']  = "#32e132";
		array_push($data, $arr);

		return $data;
	}
}
