<?php

defined('BASEPATH') OR exit('No direct script access allowed');


class ApiAlat extends CI_Controller {


	public function __construct()

    {

        parent::__construct();
	
        	$this->load->model('Model_ApiAlat','m_ApiAlat', True);

    }

    public function cek_alat()
    {
        $qrcode = $this->input->post('qrcode');
        $rs = $this->m_ApiAlat->cek_alat($qrcode);
        
        if($rs->num_rows()>0)
        {
            $data = array();
            foreach ($rs->result() as $value) {

                

                $rs2 = $this->m_ApiAlat->cek_pinjam($value->qrcode);
                
                $rs3 = $this->m_ApiAlat->cek_kalib($value->id);

                $param['kode']          = $value->qrcode;
                $param['serial_number']          = $value->serial_number;   
                $param['no_inventaris']          = $value->no_inventaris;                  
                $param['nama_alat']     = $value->nama_alat;
                $param['unit_pemilik_alat']     = $value->unit_pemilik_alat;
                $param['merk']     		= $value->merk;
                $param['tipe_alat']     = $value->tipe_alat;
                $param['lokasi']        = $value->lokasi; 
                $param['status']        = $value->status;
                $param['url_images']    = $value->url_images;
                $param['url_images2']    = $value->url_images2;

                if($rs2->num_rows() > 0){
                    $value2 = $rs2->row();
                    $pinjam = NULL;$rkembali = NULL;$kembali = NULL;
                    if($value2->tgl_pinjam != NULL){
                        $pinjam = $this->tanggal_indo(date("Y-m-d",strtotime($value2->tgl_pinjam)));
                    }
                    if($value2->lama_pinjam != NULL){
                        $rkembali = $this->tanggal_indo(date("Y-m-d",strtotime($value2->lama_pinjam)));
                    }
                    if($value2->tgl_kembali != NULL){
                        $kembali = $this->tanggal_indo(date("Y-m-d",strtotime($value2->tgl_kembali)));
                    }
                    $param['peminjam']    = $value2->nama_peminjam;
                    $param['tgl_pinjam']    = $pinjam;
                    $param['tgl_rkembali']    = $rkembali;
                    $param['tgl_kembali']    = $kembali;

                    if($value->status != "Digunakan"){
                        $ket = "Barang telah kembali";
                    }else{
                        $ket = $value2->ket_pinjam;
                    }
                }else{
                    $param['peminjam']    = NULL;
                    $param['tgl_pinjam']    = NULL;
                    $param['tgl_rkembali']    = NULL;
                    $param['tgl_kembali']    = NULL;
                    $ket = "Barang belum dipinjam";
                }


                if($rs3->num_rows() > 0){
                    $value3 = $rs3->row();
                    $kalib = NULL;$kalibber=NULL;
                    if($value3->tgl_kalibrasi != NULL){
                        $kalib = $this->tanggal_indo(date("Y-m-d",strtotime($value3->tgl_kalibrasi)));
                    }
                    if($value3->tgl_kalibrasi_berikut != NULL){
                        $kalibber = $this->tanggal_indo(date("Y-m-d",strtotime($value3->tgl_kalibrasi_berikut)));
                    }

                    $param['tgl_kalibrasi']          = $kalib;  
                    $param['tgl_kalibrasi_berikut']          = $kalibber; 
                }else{
                    $param['tgl_kalibrasi']          = NULL;  
                    $param['tgl_kalibrasi_berikut']          = NULL; 
                }
                $param['ket_pinjam']    = $ket;
                array_push($data,$param);
            }
            
            $json = array('kode_ms' => 200, 'ms' => 'Sukses', 'data' => $data);
            echo json_encode($json);
        }else{
            $json = array('kode_ms' => 404, 'ms' => 'Alat Tidak Ditemukan');
            echo json_encode($json);
        }
    }
    public function cek_alat2()
    {
        $id = $this->input->post('id');
        $rs = $this->m_ApiAlat->cek_alat2($id);
        
        if($rs->num_rows()>0)
        {
            $data = array();
            foreach ($rs->result() as $value) {
                $param['kode']          = $value->qrcode;
                $param['serial_number']          = $value->serial_number;   
                $param['no_inventaris']          = $value->no_inventaris;                  
                $param['nama_alat']     = $value->nama_alat;
                $param['unit_pemilik_alat']     = $value->unit_pemilik_alat;
                $param['merk']     		= $value->merk;
                $param['tipe_alat']     = $value->tipe_alat;
                $param['lokasi']        = $value->lokasi; 
                $param['tgl_kalibrasi']          = $value->tgl_kalibrasi;  
                $param['tgl_kalibrasi_berikut']          = $value->tgl_kalibrasi_berikut; 
                $param['keterangan']    = $value->ket;
                $param['ket_pinjam']    = $value->ket_pinjam;
                $param['status']        = $value->status;
                $param['peminjam']    = $value->nama_peminjam;
                $param['tgl_pinjam']    = $value->tgl_pinjam;
                $param['tgl_rkembali']    = $value->tgl_rkembali;
                $param['tgl_kembali']    = $value->tgl_kembali;
                $param['url_images']    = $value->url_images;
                $param['url_images2']    = $value->url_images2;
                array_push($data,$param);
            }
            
            $json = array('kode_ms' => 200, 'ms' => 'Sukses', 'data' => $data);
            echo json_encode($json);
        }else{
            $json = array('kode_ms' => 404, 'ms' => 'Alat Tidak Ditemukan');
            echo json_encode($json);
        }
    }
    public function cek_login()
    {
        $username = $this->input->post('username');
        $password = md5($this->input->post('password'));

        $rs = $this->m_ApiAlat->cek_login($username,$password)->row();
        if($rs)
        {
            $json = array('kode_ms' => 200, 'ms' => 'Sukses');
            echo json_encode($json);
        }else{

            $json = array('kode_ms' => 404, 'ms' => 'Gagal');
            echo json_encode($json);
        }
    }
    public function get_alat()
    {
        $qrcode = $this->input->post('qrcode');
        $rs = $this->m_ApiAlat->cek_alat($qrcode);
        
        if($rs->num_rows()>0)
        {
            $data = array();
            foreach ($rs->result() as $value) {
                $param['id']          	= $value->id_pinjam;
                $param['kode']          = $value->qrcode;               
                $param['nama_alat']     = $value->nama_alat;
                $param['unit_pemilik_alat']     = $value->unit_pemilik_alat;
                $param['merk']     		= $value->merk;
                $param['tipe_alat']     = $value->tipe_alat;
                $param['status']     	= $value->status;
                $param['url_images']    = $value->url_images;
                $param['url_images2']    = $value->url_images2;
                array_push($data,$param);
            }

            $json = array('kode_ms' => 200, 'ms' => 'Sukses', 'data' => $data);
            echo json_encode($json);
        }else{
            $json = array('kode_ms' => 404, 'ms' => 'Alat Tidak Ditemukan');
            echo json_encode($json);
        }
    }
    // public function get_alat_digunakan()
    // {
    //     $qrcode = $this->input->post('qrcode');
    //     $rs = $this->m_ApiAlat->cek_alat($qrcode);
        
    //     if($rs->num_rows()>0)
    //     {
    //         $data = array();
    //         foreach ($rs->result() as $value) {
    //             $param['id']          	= $value->id_pinjam;
    //             $param['kode']          = $value->qrcode;
    //             $param['nama_alat']     = $value->nama_alat;                
    //             $param['merk']     		= $value->merk;
    //             $param['tipe_alat']     = $value->tipe_alat;
    //             $param['status']     	= $value->status;
    //             $param['peminjam']     	= $value->nama_peminjam;
    //             $param['url_images']    = $value->url_images;
    //             $param['url_images2']    = $value->url_images2;
    //             array_push($data,$param);
    //         }

    //         $json = array('kode_ms' => 200, 'ms' => 'Sukses', 'data' => $data);
    //         echo json_encode($json);
    //     }else{
    //         $json = array('kode_ms' => 404, 'ms' => 'Alat Tidak Ditemukan');
    //         echo json_encode($json);
    //     }
    // }
    public function get_alat_digunakan()
    {
        $qrcode = $this->input->post('qrcode');
        $rs = $this->m_ApiAlat->cek_alat($qrcode);
        
        if($rs->num_rows()>0)
        {
            $data = array();
            foreach ($rs->result() as $value) {

                

                $rs2 = $this->m_ApiAlat->cek_pinjam($value->qrcode);
                
                $rs3 = $this->m_ApiAlat->cek_kalib($value->id);
                
                $param['kode']          = $value->qrcode;
                $param['serial_number']          = $value->serial_number;   
                $param['no_inventaris']          = $value->no_inventaris;                  
                $param['nama_alat']     = $value->nama_alat;
                $param['unit_pemilik_alat']     = $value->unit_pemilik_alat;
                $param['merk']     		= $value->merk;
                $param['tipe_alat']     = $value->tipe_alat;
                $param['lokasi']        = $value->lokasi; 
                $param['status']        = $value->status;
                $param['url_images']    = $value->url_images;
                $param['url_images2']    = $value->url_images2;

                if($rs2->num_rows() > 0){
                    $value2 = $rs2->row();
                    $pinjam = NULL;$rkembali = NULL;$kembali = NULL;
                    if($value2->tgl_pinjam != NULL){
                        $pinjam = $this->tanggal_indo(date("Y-m-d",strtotime($value2->tgl_pinjam)));
                    }
                    if($value2->lama_pinjam != NULL){
                        $rkembali = $this->tanggal_indo(date("Y-m-d",strtotime($value2->lama_pinjam)));
                    }
                    if($value2->tgl_kembali != NULL){
                        $kembali = $this->tanggal_indo(date("Y-m-d",strtotime($value2->tgl_kembali)));
                    }
                    $param['peminjam']    = $value2->nama_peminjam;
                    $param['id']          	= $value2->id;
                    $param['tgl_pinjam']    = $pinjam;
                    $param['tgl_rkembali']    = $rkembali;
                    $param['tgl_kembali']    = $kembali;

                    if($value->status != "Digunakan"){
                        $ket = "Barang telah kembali";
                    }else{
                        $ket = $value2->ket_pinjam;
                    }
                }else{
                    $param['peminjam']    = NULL;
                    $param['tgl_pinjam']    = NULL;
                    $param['tgl_rkembali']    = NULL;
                    $param['tgl_kembali']    = NULL;
                    $ket = "Barang belum dipinjam";
                }


                if($rs3->num_rows() > 0){
                    $value3 = $rs3->row();
                    $kalib = NULL;$kalibber=NULL;
                    if($value3->tgl_kalibrasi != NULL){
                        $kalib = $this->tanggal_indo(date("Y-m-d",strtotime($value3->tgl_kalibrasi)));
                    }
                    if($value3->tgl_kalibrasi_berikut != NULL){
                        $kalibber = $this->tanggal_indo(date("Y-m-d",strtotime($value3->tgl_kalibrasi_berikut)));
                    }

                    $param['tgl_kalibrasi']          = $kalib;  
                    $param['tgl_kalibrasi_berikut']          = $kalibber; 
                }else{
                    $param['tgl_kalibrasi']          = NULL;  
                    $param['tgl_kalibrasi_berikut']          = NULL; 
                }
                $param['ket_pinjam']    = $ket;
                array_push($data,$param);
            }
            
            $json = array('kode_ms' => 200, 'ms' => 'Sukses', 'data' => $data);
            echo json_encode($json);
        }else{
            $json = array('kode_ms' => 404, 'ms' => 'Alat Tidak Ditemukan');
            echo json_encode($json);
        }
    }
    public function simpan_new_alat()
    {
        
                $tempName = "alat_".time();

                $config['upload_path'] = './assets/alat/';
                $config['file_name'] = $tempName;          
                $config['allowed_types'] = 'jpg|png|pdf';           
                $config['max_size']    = 2000;

                $this->load->library('upload');
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('image'))
                {  
                   echo json_encode(array( "status" => "false","message" => "Failed!") );
                }else
                {
                    $file = $this->upload->data();

                    $url ="https://alat.sbuindustri.com/assets/alat/".$file['file_name'];
        
                    $data = array(
                    'qrcode' => trim($this->input->post('qrcode')),           
                    'nama_alat' => trim($this->input->post('nama_alat')),
                    'unit_pemilik_alat' => trim($this->input->post('unit_pemilik_alat')),
                    'merk' => trim($this->input->post('merk')),
                    'tipe_alat' => trim($this->input->post('tipe_alat')),                      
                    'lokasi' => trim($this->input->post('lokasi')),
                    'ket' => trim($this->input->post('ket_alat')),
                    'status' => 'Ada',
                    'tgl' => date('Y-m-d H:i:s'),
                    'url_images' => $url
                    );

                    $rs = $this->m_ApiAlat->insert_new_alat($data);
                    if($rs)
                    {
                        $json = array('kode_ms' => 200, 'ms' => 'Sukses Simpan Alat');            
                    }else{
                        $json = array('kode_ms' => 300, 'ms' => 'Gagal Simpan');
                       
                    }
                 echo json_encode($json);
                }

    }
    public function simpan_new_alat2()
    {
        //CEK
        $qr = trim($this->input->post('qrcode'));
        $cekqr = $this->m_ApiAlat->cek_qr($qr);
        if($cekqr->num_rows() <= 0)
        {
            $json = array('kode_ms' => 300, 'ms' => 'QR Tidak Tersedia');
        }else{
            $rowqr = $cekqr->row();
            if(!is_null($rowqr->id_alat)){
                $json = array('kode_ms' => 300, 'ms' => 'QR Telah Terdaftar');
            }else{
                $tempName = "alat_".time();

                $config['upload_path'] = './assets/alat/';
                $config['file_name'] = $tempName;          
                $config['allowed_types'] = 'jpg|png|pdf';           
                $config['max_size']    = 2000;

                $this->load->library('upload');
                $this->upload->initialize($config);

                    
                        $this->upload->do_upload('image');
                        $dataInfo = $this->upload->data();
                        
                   
                        $this->upload->do_upload('image2');
                        $dataInfo2 = $this->upload->data(); 

                        $url2 ="https://alat.sbuindustri.com/assets/alat/".$dataInfo2['file_name'];
                        $url ="https://alat.sbuindustri.com/assets/alat/".$dataInfo['file_name'];

        
                    $data = array(
                        'qrcode' => trim($this->input->post('qrcode')),           
                        'serial_number' => trim($this->input->post('serial_number')),           
                        'nama_alat' => trim($this->input->post('nama_alat')),
                        'unit_pemilik_alat' => trim($this->input->post('unit_pemilik_alat')),
                        'merk' => trim($this->input->post('merk')),
                        'tipe_alat' => trim($this->input->post('tipe_alat')),                      
                        'lokasi' => trim($this->input->post('lokasi')),
                        'ket' => trim($this->input->post('ket_alat')),
                        'status' => 'Ada',
                        'tgl' => date('Y-m-d H:i:s'),
                        'url_images' => $url,
                        'url_images2' => $url2,
                        'no_inventaris' => trim($this->input->post('no_inventaris')),  
                    );

                    $rs = $this->m_ApiAlat->insert_new_alat($data);
                    if($rs)
                    {
                        $data2 = array(
                            'id_alat' => $rs,           
                            'tgl_kalibrasi' => trim($this->input->post('tgl_kalibrasi')),           
                            'tgl_kalibrasi_berikut' => trim($this->input->post('tgl_kalibrasi_berikut')) 
                        );
                        $rs2 = $this->m_ApiAlat->insert_kalibrasi($data2);
                        if($rs2){ 
                            $json = array('kode_ms' => 200, 'ms' => 'Sukses Simpan Alat');   
                        }else{
                            $json = array('kode_ms' => 200, 'ms' => 'Sukses Simpan Alat');   
                        }    
                    }else{
                        $json = array('kode_ms' => 300, 'ms' => 'Gagal Simpan');
                       
                    }  
                }
        }
                 echo json_encode($json);
                    

    }
    public function pinjam_alat(){
        
        $id = trim($this->input->post('qrcode'));
        $lokasi = trim($this->input->post('lokasi'));
        $data = array(
            'qr'   => trim($this->input->post('qrcode')),
            'lokasi' => trim($this->input->post('lokasi')),
            'ket_pinjam' => trim($this->input->post('ket_pinjam')),
            'tgl_pinjam' => date('Y-m-d H:i:s'),
            'lama_pinjam' => date('Y-m-d H:i:s',strtotime($this->input->post('tgl_kembali'))),
            'nama_peminjam' => trim($this->input->post('peminjam'))

        );

        $rs = $this->m_ApiAlat->update_alat($lokasi,$id);
        if($rs)
        {
            $this->m_ApiAlat->simpan_pinjam($data);
            $json = array('kode_ms' => 200, 'ms' => 'Sukses Pinjam Alat');            
        }else{
            $json = array('kode_ms' => 300, 'ms' => 'Gagal Pinjam Alat');
           
        }
         echo json_encode($json);

    }
    public function pengembalian(){
        
        $qr = trim($this->input->post('qrcode'));
        $id = trim($this->input->post('id'));        
         $data = array(            
            'tgl_kembali' => date('Y-m-d H:i:s')

        );

        $rs = $this->m_ApiAlat->update_sts($qr);
        if($rs)
        {
            $this->m_ApiAlat->kembali($id,$data);
            $json = array('kode_ms' => 200, 'ms' => 'Sukses pengembalian');            
        }else{
            $json = array('kode_ms' => 300, 'ms' => 'Gagal pengembalian');
           
        }
         echo json_encode($json);

    }
    public function kalibrasi_alat(){
        
        $qrcode = trim($this->input->post('qrcode'));
        $qr = $this->m_ApiAlat->cek_alat($qrcode)->row_array();
        $data = array(
            'id_alat'   => $qr['id'],
            'tgl_kalibrasi' => trim($this->input->post('tgl_kalibrasi')),
            'tgl_kalibrasi_berikut' => trim($this->input->post('tgl_kalibrasi_berikut')),
            'keterangan' => trim($this->input->post('ket_kalib'))

        );

        $rs = $this->m_ApiAlat->insert_kalibrasi($data);
        if($rs)
        {
            $json = array('kode_ms' => 200, 'ms' => 'Sukses Kalibrasi Alat');            
        }else{
            $json = array('kode_ms' => 300, 'ms' => 'Gagal kalibrasi_alat Alat');
           
        }
         echo json_encode($json);

    }


    public function cek_alat_semua()
    {
        $query = "";
        if(null != $this->input->post('query')){
            $query=$this->input->post('query');
        }
        $rs = $this->m_ApiAlat->cek_alat_semua($query);
        if($rs->num_rows()>0)
        {
            $data = array();
            foreach ($rs->result() as $value) {
                $param['id']          = $value->id;
                $param['kode']          = $value->qrcode;
                $param['serial_number']          = $value->serial_number;   
                $param['no_inventaris']          = $value->no_inventaris;                  
                $param['nama_alat']     = $value->nama_alat;
                $param['unit_pemilik_alat']     = $value->unit_pemilik_alat;
                $param['merk']     		= $value->merk;
                $param['tipe_alat']     = $value->tipe_alat;
                $param['lokasi']        = $value->lokasi; 
                $param['status']        = $value->status;
                $param['url_images']    = $value->url_images;
                $param['url_images2']    = $value->url_images2;

                $rs2 = $this->m_ApiAlat->cek_pinjam($value->qrcode);
                
                $rs3 = $this->m_ApiAlat->cek_kalib($value->id);

                if($rs2->num_rows() > 0){
                    $value2 = $rs2->row();
                    $pinjam = NULL;$rkembali = NULL;$kembali = NULL;
                    if($value2->tgl_pinjam != NULL){
                        $pinjam = $this->tanggal_indo(date("Y-m-d",strtotime($value2->tgl_pinjam)));
                    }
                    if($value2->lama_pinjam != NULL){
                        $rkembali = $this->tanggal_indo(date("Y-m-d",strtotime($value2->lama_pinjam)));
                    }
                    if($value2->tgl_kembali != NULL){
                        $kembali = $this->tanggal_indo(date("Y-m-d",strtotime($value2->tgl_kembali)));
                    }
                    $param['peminjam']    = $value2->nama_peminjam;
                    $param['tgl_pinjam']    = $pinjam;
                    $param['tgl_rkembali']    = $rkembali;
                    $param['tgl_kembali']    = $kembali;

                    if($value->status != "Digunakan"){
                        $ket = "Barang telah kembali";
                    }else{
                        $ket = $value2->ket_pinjam;
                    }
                }else{
                    $param['peminjam']    = NULL;
                    $param['tgl_pinjam']    = NULL;
                    $param['tgl_rkembali']    = NULL;
                    $param['tgl_kembali']    = NULL;
                    $ket = "Barang belum dipinjam";
                }


                if($rs3->num_rows() > 0){
                    $value3 = $rs3->row();
                    $kalib = NULL;$kalibber=NULL;
                    if($value3->tgl_kalibrasi != NULL){
                        $kalib = $this->tanggal_indo(date("Y-m-d",strtotime($value3->tgl_kalibrasi)));
                    }
                    if($value3->tgl_kalibrasi_berikut != NULL){
                        $kalibber = $this->tanggal_indo(date("Y-m-d",strtotime($value3->tgl_kalibrasi_berikut)));
                    }

                    $param['tgl_kalibrasi']          = $kalib;  
                    $param['tgl_kalibrasi_berikut']          = $kalibber; 
                }else{
                    $param['tgl_kalibrasi']          = NULL;  
                    $param['tgl_kalibrasi_berikut']          = NULL; 
                }
                $param['ket_pinjam']    = $ket;

                array_push($data,$param);
            }
            
            $json = array('kode_ms' => 200, 'ms' => 'Sukses', 'data' => $data);
            echo json_encode($json);
        }else{
            $json = array('kode_ms' => 404, 'ms' => 'Alat Tidak Ditemukan');
            echo json_encode($json);
        }
    }


    public function ubah_alat()
    {
        //CEK
        $id = trim($this->input->post('id'));
        $qr = trim($this->input->post('qrcode'));
        $cekqr = $this->m_ApiAlat->cek_qr($qr);
        if($cekqr->num_rows() <= 0)
        {
            $json = array('kode_ms' => 300, 'ms' => 'QR Tidak Tersedia');
        }else{
            $rowqr = $cekqr->row();
            if((!is_null($rowqr->id_alat)) and ($rowqr->id_alat != $id)){
                $json = array('kode_ms' => 300, 'ms' => 'QR Telah Terdaftar');
            }else{
                $tempName = "alat_".time();

                $config['upload_path'] = './assets/alat/';
                $config['file_name'] = $tempName;          
                $config['allowed_types'] = 'jpg|png|pdf';           
                $config['max_size']    = 2000;

                $this->load->library('upload');
                $this->upload->initialize($config);
                
                    $data = array(
                        'qrcode' => trim($this->input->post('qrcode')),           
                        'serial_number' => trim($this->input->post('serial_number')),           
                        'nama_alat' => trim($this->input->post('nama_alat')),
                        'unit_pemilik_alat' => trim($this->input->post('unit_pemilik_alat')),
                        'merk' => trim($this->input->post('merk')),
                        'tipe_alat' => trim($this->input->post('tipe_alat')),                      
                        'lokasi' => trim($this->input->post('lokasi')),
                        'ket' => trim($this->input->post('ket_alat')),
                        'tgl' => date('Y-m-d H:i:s'),
                        'no_inventaris' => trim($this->input->post('no_inventaris')),  
                    );

                    if($this->upload->do_upload('image'))
                    {
                            //$this->upload->do_upload('image');
                            $dataInfo = $this->upload->data();
                            $url ="https://alat.sbuindustri.com/assets/alat/".$dataInfo['file_name'];
                            $data['url_images'] = $url;
                    }        
                    if($this->upload->do_upload('image2'))
                    {   
                            //$this->upload->do_upload('image2');
                            $dataInfo2 = $this->upload->data(); 
                            $url2 ="https://alat.sbuindustri.com/assets/alat/".$dataInfo2['file_name'];
                            $data['url_images2'] = $url2;
                    }

                    $rs = $this->m_ApiAlat->update_alat_baru($data,$id);
                    if($rs)
                    {
                        $data2 = array(
                            'id_alat' => $rs,           
                            'tgl_kalibrasi' => trim($this->input->post('tgl_kalibrasi')),           
                            'tgl_kalibrasi_berikut' => trim($this->input->post('tgl_kalibrasi_berikut')) 
                        );
                        $rs2 = $this->m_ApiAlat->insert_kalibrasi($data2);
                        if($rs2){ 
                            $json = array('kode_ms' => 200, 'ms' => 'Sukses Ubah Alat');   
                        }else{
                            $json = array('kode_ms' => 200, 'ms' => 'Sukses Ubah Alat');   
                        }    
                    }else{
                        $json = array('kode_ms' => 300, 'ms' => 'Gagal Ubah');
                       
                    }  
                }
        }
                 echo json_encode($json);
                    

    }
    public function tes_tes()
    {
        $data = array(
            'qrcode' => "aaa",           
            'serial_number' => "bbb",           
            'nama_alat' => "ccc");
        $data['baru'] = "ddd";
        echo json_encode($data);
    }

    function tanggal_indo($tanggal)
    {
      $bulan = array (1 =>   'Januari',
            'Februari',
            'Maret',
            'April',
            'Mei',
            'Juni',
            'Juli',
            'Agustus',
            'September',
            'Oktober',
            'November',
            'Desember'
          );
      $split = explode('-', $tanggal);
      return $split[2] . ' ' . $bulan[ (int)$split[1] ] . ' ' . $split[0];
    }
}